#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ComponentClass : BaseTest 
	{

		private DataRow _drComponentClass;
		private BOL.ComponentClass _componentClass;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
			//
			if (this.RefreshData)
			{
				_drComponentClass = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM ComponentClass");
				this.RefreshData = false;
			}
			//
			_componentClass = new BOL.ComponentClass(Convert.ToInt32(this._drComponentClass[TABLES.ComponentClass.ComponentClassId]));
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.ComponentClass tmpObject = new BOL.ComponentClass(Convert.ToInt32(this._drComponentClass[TABLES.ComponentClass.ComponentClassId]));
			//
			Assert.AreEqual(_componentClass.ComponentClassId,tmpObject.ComponentClassId);
			Assert.AreEqual(_componentClass.Name,tmpObject.Name);
			//
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_Fail()
		{
			BOL.ComponentClass tmpObject = new BOL.ComponentClass(0);
			//
			Assert.AreEqual(_componentClass.ComponentClassId,tmpObject.ComponentClassId);
		}

		[Test]
		public void ComponentClassId_Pass()
		{
			Assert.AreEqual(Convert.ToInt32(this._drComponentClass[TABLES.ComponentClass.ComponentClassId]),_componentClass.ComponentClassId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ComponentClassId_Fail()
		{
		}

		[Test]
		public void ComponentClassShortName_Pass()
		{
			Assert.AreEqual(this._drComponentClass[TABLES.ComponentClass.ComponentClassShortName].ToString(),_componentClass.ComponentClassShortName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ComponentClassShortName_Fail()
		{
		}

		[Test]
		public void Name_Pass()
		{
			Assert.AreEqual(this._drComponentClass[TABLES.ComponentClass.ComponentClassName].ToString(),_componentClass.Name);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Name_Fail()
		{
		}

		[Test]
		public void CprsOrderableItemId_Pass()
		{
			Assert.AreEqual(this._drComponentClass[TABLES.ComponentClass.CprsOrderableItemId].ToString(),_componentClass.CprsOrderableItemId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CprsOrderableItemId_Fail()
		{
		}

		[Test]
		public void SortColumn_Pass()
		{
			Assert.AreEqual(Convert.ToInt16(this._drComponentClass[TABLES.ComponentClass.SortColumn]),_componentClass.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			Assert.AreEqual(Convert.ToDateTime(this._drComponentClass[TABLES.ComponentClass.LastUpdateDate]),_componentClass.LastUpdateDate);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			Assert.AreEqual(this._drComponentClass[TABLES.ComponentClass.LastUpdateUser].ToString(),_componentClass.LastUpdateUser);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateUser_Fail()
		{
		}
		[Test]
		public void RowVersion_Pass()
		{
			Assert.AreEqual(this._drComponentClass[TABLES.ComponentClass.RowVersion].ToString(),_componentClass.RowVersion.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void GetComponentClass_Pass()
		{
			BOL.ComponentClass tmpObject = BOL.ComponentClass.GetComponentClass(_componentClass.ComponentClassId);
			//
			Assert.AreEqual(_componentClass.ComponentClassId,tmpObject.ComponentClassId);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetComponentClass_Fail()
		{
			BOL.ComponentClass tmpObject = BOL.ComponentClass.GetComponentClass(0);
			//
			Assert.AreEqual(_componentClass.ComponentClassId,tmpObject.ComponentClassId);

		}
	}
}
#endif
